//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace Messenger
{
	public enum StatusMessageType
	{
		Status = 0,
		Request,
		Response
	};

	/// <summary>
	/// Podsumowanie dla StatusForm.
	/// </summary>
	public class StatusForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.RichTextBox statusTextBox;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public void StatusCallback(StatusMessageType type, string message)
		{
			if(type == StatusMessageType.Status)
				statusTextBox.SelectionColor = Color.Black;
			if(type == StatusMessageType.Request)
				statusTextBox.SelectionColor = Color.Blue;
			if(type == StatusMessageType.Response)
				statusTextBox.SelectionColor = Color.Red;
			statusTextBox.AppendText(message + "\r\n");
		}

		public StatusForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			//
			// TODO: Dodanie kodu konstruktora po wywoaniu InitializeComponent
			//
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			this.statusTextBox = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// statusTextBox
			// 
			this.statusTextBox.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.statusTextBox.Location = new System.Drawing.Point(10, 20);
			this.statusTextBox.Name = "statusTextBox";
			this.statusTextBox.Size = new System.Drawing.Size(686, 286);
			this.statusTextBox.TabIndex = 1;
			this.statusTextBox.Text = "";
			// 
			// StatusForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(706, 333);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.statusTextBox});
			this.Name = "StatusForm";
			this.Text = "Status";
			this.ResumeLayout(false);

		}
		#endregion
	}
}
